$(document).ready(async function () {

    const validarCampoPedido = await CopiaParametro("RECEBER", 13) == '1';
    const valoresPadroes = await buscaValoresPadroes('RECEBER');
    let bRemoverClienteSPC = null;

    $('#txtNovoClienteDesdobra').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#btnNovoClienteDesdobra').pesquisa('#txtNovoClienteDesdobra', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "ENTIDADE","camposSelect": ["CODCLI", "NOME"]}`, 'Pesquisa Cliente', 'ENTIDADE');

    $('#btnANovoClienteDesdobra').on('click', function () {
        $('#txtNovoClienteDesdobra').val('');
    });

    $('#modal-desdobra-receber').on('shown.bs.modal', async function () {
        $.LoadingOverlay('show');
        try {
            $('#txtDataBaseDesdobra').val(formataData(new Date()));
            $('#txtDataVenctoDesdobra').val(formataData(new Date()));
            $('#txtParcelasDesdobra').val('1');
            $('#txtIntervaloDesdobra').val('0');
            await carregaDadosReceber();
            bRemoverClienteSPC = $("#modal-desdobra-receber").prop("bRemoverClienteSPC");
            if (bRemoverClienteSPC === false) {
                bloqueiaTelaClienteSPC();
            } else {
                bloqueiaTelaClienteSPC(false);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    adicionaMascaraCampos();

    function adicionaMascaraCampos() {
        $('.apenasFloat').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.apenasInteiros').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 0,
        });
    };

    async function carregaDadosReceber() {
        try {
            const numeros = $("#tabelaReceber").DataTable().rows(".selected").data().toArray().map(function (e) { return e.NUMERO });

            let response = await requisicao('GET', '/Sisplan/desdobrareceber/V1/buscareceber?', `&NUMEROS=${numeros}`, null);

            if (!response) {
                return;
            }

            const dadosSel = await response.json();

            await criaTabelaSelecionadas(dadosSel.DADOS);

            if (dadosSel.SOMENTE_CONSULTA) {
                $('#divDesdobradas div input, #divDesdobradas div select, #divDesdobradas div button').prop('disabled', true);
                $('#btnGravarDesdobra').prop('disabled', true);
                $('#divDesdobradas').addClass('d-none');
                $('#textoVisualizacao').removeClass('d-none');
            } else {
                $('#divDesdobradas div input, #divDesdobradas div select, #divDesdobradas div button').prop('disabled', false);
                $('#btnGravarDesdobra').prop('disabled', false);
                $('#divDesdobradas').removeClass('d-none');
                $('#textoVisualizacao').addClass('d-none');
            }

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível carregar os dados: ${e}`);
        }
    }

    async function criaTabelaSelecionadas(info) {
        if ($.fn.DataTable.isDataTable('#tabelaDupliSelDesdobra')) {
            $('#tabelaDupliSelDesdobra').DataTable().destroy();
            $('#tabelaDupliSelDesdobra').empty();
        }

        const cols = [{
            data: 'NUMERO',
            title: 'Número'
        },
        {
            data: 'STATUS',
            title: 'Status'
        },
        {
            data: 'DT_EMISSAO',
            title: 'Emissão'
        },
        {
            data: 'DT_VENCTO',
            title: 'Vencimento'
        },
        {
            data: 'SALDO',
            title: 'Valor'
        },
        {
            data: 'JUROS_CALC',
            title: 'Juros Calc.'
        },
        {
            data: 'VALOR_CALC',
            title: 'Valor Calc.'
        },
        {
            data: 'CODCLI',
            title: 'Codcli'
        },
        {
            data: 'NOME',
            title: 'Nome'
        }]

        $("#tabelaDupliSelDesdobra").DataTable({
            order: false,
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            searching: false,
            info: false,
            autoWidth: true,
            data: info,
            columns: cols,
            columnDefs: [
                {
                    targets: [4, 5, 6],
                    render: function (data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                },
                {
                    type: "date-br",
                    render(data) {
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                    targets: [2, 3],
                },
            ],
        });

        $('#tabelaDupliSelDesdobra').on('click', 'tr', async function () {
            $.LoadingOverlay('show');
            try {
                $('#tabelaDupliSelDesdobra').DataTable().$('tr.selected').removeClass('selected');
                const data = $('#tabelaDupliSelDesdobra').DataTable().row($(this)).data();
                $(this).addClass('selected');
                await buscaAssociadas(data);
            } finally {
                $.LoadingOverlay('hide');
            }
        });

        $('#labelTotalValor').html(parseFloat($('#tabelaDupliSelDesdobra').DataTable().data().toArray().reduce((e, o) => {
            return e + o.SALDO;
        }, 0)).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        })
        );

        $('#labelTotalSoma').html(parseFloat(0).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        }));

        $('#labelTotalSaldo').html(parseFloat(0).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        }));

        if ($('#tabelaDupliSelDesdobra').DataTable().data().length > 0) {
            $($('#tabelaDupliSelDesdobra tr')[1]).trigger('click');
        }

    }

    async function buscaAssociadas(data) {
        try {

            let response = await requisicao('GET', '/Sisplan/desdobrareceber/V1/buscaassociadas?', `&NUMERO=${data.NUMERO}&STATUS=${data.STATUS}`, null);

            if (!response) {
                return;
            }

            const dadosAss = await response.json();

            if (dadosAss.length > 0) {
                criaTabelaAssociadas(dadosAss);
                $('#divSel').addClass('col-7');
                $('#divSel').removeClass('col-12');
                $('#divAss').removeClass('d-none');
                $('#tituloAss').removeClass('d-none');
            } else {
                $('#divSel').removeClass('col-7');
                $('#divSel').addClass('col-12');
                $('#divAss').addClass('d-none');
                $('#tituloAss').addClass('d-none');
            }

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    function criaTabelaAssociadas(info) {
        if ($.fn.DataTable.isDataTable('#tabelaDupliAssDesdobra')) {
            $('#tabelaDupliAssDesdobra').DataTable().destroy();
            $('#tabelaDupliAssDesdobra').empty();
        }
        const cols = [
            {
                data: 'NUMERO',
                title: 'Número'
            },
            {
                data: 'STATUS',
                title: 'Status'
            },
            {
                data: 'DT_EMISSAO',
                title: 'Emissão'
            },
            {
                data: 'DT_VENCTO',
                title: 'Vencimento'
            },
            {
                data: 'SALDO',
                title: 'Saldo'
            }];

        $("#tabelaDupliAssDesdobra").DataTable({
            order: false,
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            searching: false,
            info: false,
            autoWidth: true,
            data: info,
            columns: cols,
            columnDefs: [
                {
                    targets: [4],
                    render: function (data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                },
                {
                    type: "date-br",
                    render(data) {
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                    targets: [2, 3],
                },
            ],
        });
    }

    $('#btnProcessarDesdobra').on('click', function () {
        $.LoadingOverlay('show');
        try {

            const dataBase = $('#txtDataBaseDesdobra').val();
            const taxaJuros = $('#txtTaxaJurosDesdobra').val();

            if (dataBase == '') {
                msgErro('Data base não informada. Impossível continuar.');
                return;
            }

            if (taxaJuros == '') {
                msgErro('Taxa de juros não informada. Impossível continuar.');
                return;
            }

            processaJuros(dataBase, taxaJuros);

            $('#labelTotalValor').html(parseFloat($('#tabelaDupliSelDesdobra').DataTable().data().toArray().reduce((e, o) => {
                return e + o.VALOR_CALC;
            }, 0)).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            })
            );

        } finally {
            $.LoadingOverlay('hide');
        }
    })

    function processaJuros(data, juros) {
        try {
            const dados = $('#tabelaDupliSelDesdobra').DataTable().data().toArray();

            dados.map(function (e) {
                if (e.DT_VENCTO < data) {
                    let dias = daysBetween(new Date(e.DT_VENCTO), new Date(data));
                    let taxa = dias / 30;
                    taxa = taxa * juros;
                    let valorJuros = (e.SALDO * taxa) / 100;

                    e.JUROS_CALC = valorJuros;
                    e.VALOR_CALC = parseFloat(parseFloat(e.SALDO + valorJuros).toFixed(2));
                }
            });

            criaTabelaSelecionadas(dados);
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível processar os dados: ${e}`);
        }
    }

    $('#btnTrocarClienteDesdobra').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const novoCliente = pegaChave('#txtNovoClienteDesdobra');

            if (novoCliente == '') {
                msgErro('É necessário informar um novo cliente. Impossível continuar.');
                return;
            }

            msgAlerta('Deseja realmente atualizar o cliente das duplicatas selecionadas?', () => { }, () => { }, async () => {
                await alteraCliente(novoCliente);
            });

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function alteraCliente(cliente) {
        try {

            const numeros = $("#tabelaDupliSelDesdobra").DataTable().data().toArray().map(function (e) { return e.NUMERO });

            let response = await requisicao("POST", `/Sisplan/desdobrareceber/V1/alteracliente?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
                `&CLIENTE=${cliente}&NUMEROS=${numeros}`);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                throw (response.statusText);
            }

            toastr.success("Cliente alterado com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 1500,
                fadeOut: 1000,
                async onHidden() {
                    $.LoadingOverlay('show');
                    try {
                        await carregaDadosReceber();
                    } finally {
                        $.LoadingOverlay('hide');
                    }
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e.message}`);
        }
    }

    function retornaFiltros() {
        const retorno = {};

        retorno.PARCELAS = formataInt($('#txtParcelasDesdobra').val());
        retorno.INTERVALO = formataInt($('#txtIntervaloDesdobra').val());
        retorno.PRIMEIRO_VENCIMENTO = $('#txtDataVenctoDesdobra').val() == '' ? formataData(new Date()) : $('#txtDataVenctoDesdobra').val();
        retorno.TAXA_JUROS = formataFloat($('#txtTaxaJuros2Desdobra').val());
        retorno.VALOR_ENTRADA = formataFloat($('#txtValorEntradaDesdobra').val());
        retorno.PREFIXO = $('#txtPrefixoDesdobra').val();
        retorno.NSU = $('#txtNSUDesdobra').val();
        retorno.METODO = $('#txtMetodoDesdobra').val();
        retorno.VENCTO_MESMO_DIA = $('#cbVenctoDiaDesdobra').prop('checked');
        retorno.MANTER_VENCTO = $('#cbManterVenctoDesdobra').prop('checked');
        retorno.IGNORAR_FDS = $('#cbIgnorarFdsDesdobra').prop('checked');
        retorno.NUMERO_DUPLICATA = $('#cbNumeroDupliDesdobra').prop('checked');
        retorno.NUMERO_SEQUENCIAL = $('#cbGeraSeqDesdobra').prop('checked');

        return retorno;
    }

    $('#btnGerarDesdobra').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            if (($('#txtValorEntradaDesdobra').val() > 0) && ($('#txtDataVenctoDesdobra').val() == formataData(new Date()))) {
                msgAlerta('Desdobramento possui valor de entrada. A parcela de entrada terá a data de hoje. Deseja realmente continuar?', () => { }, () => { }, async () => { await desdobraDuplicatas(); })
                return;
            }

            await desdobraDuplicatas();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function formataInt(v) {
        let result;
        if (v == '') {
            return 0;
        }

        try {
            result = parseInt(v);

            if (result == 'NaN') {
                result = 0;
            }
        } catch (e) {
            result = 0;
        }

        return result;
    }
    function formataFloat(v) {
        let result;
        if (v == '') {
            return 0;
        }

        try {
            result = parseFloat(parseFloat(v).toFixed(2));

            if (result == 'NaN') {
                result = 0;
            }
        } catch (e) {
            result = 0;
        }

        return result;
    }

    async function desdobraDuplicatas() {
        try {
            const dadosSel = $('#tabelaDupliSelDesdobra').DataTable().row($('tr.selected')).data();
            if (dadosSel == undefined) {
                msgErro('É necessário selecionar uma duplicata para desdobrar.');
                return;
            }

            let numeros = [dadosSel.NUMERO];

            $("#tabelaDupliSelDesdobra").DataTable().data().toArray().map(function (e) { if (e.NUMERO != dadosSel.NUMERO) { numeros.push(e.NUMERO) } });
            const filtros = retornaFiltros();
            const valor = $('#labelTotalValor').html();

            let response = await requisicao("GET", `/Sisplan/desdobrareceber/V1/desdobraduplicatas?`, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&NUMEROS=${numeros}&EMP_ID=${getCookie('emp_id')}&VALOR=${valor}`);

            let json = await response.json();

            criaTabelaDesdobradas(json);

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    function atualizaValor(indices) {
        try {
            let parcelasValor = $('#txtParcelasDesdobra').val();
            let inputId = `#txtDupliDesdobra_${indices.row}`;
            let valorAtual = $(inputId).val();

            if ($('#cbConsParcelaDup').is(':checked')) {
                if (!valorAtual.includes(`/${parcelasValor}`)) {
                    valorAtual += `/${parcelasValor}`;
                    $(inputId).val(valorAtual);
                }
            } else {
                valorAtual = valorAtual.replace(`/${parcelasValor}`, '');
                $(inputId).val(valorAtual);
            }
        } catch (e) {
            msgErro(`Não foi possível carregar os dados: ${e}`);
            console.log(e);
        }
    }

    function criaTabelaDesdobradas(info) {

        function adjustWidth(input) {
            var text = input.value;

            // Set the width of the input based on the text content
            input.style.width = (text.length + 1) * 8 + 'px';
        }

        function carregaInput(valor, indices) {
            try {

                switch (indices.col) {
                    case 0: {
                        return `<input type="text" id="txtDupliDesdobra_${indices.row}"
                                class="input-default focus form-control tamanhoDinamico"
                                style="min-width: 15ch; max-width: 20ch" value="${valor}">`;
                    }
                    case 1: {
                        return `<input type="date" id="txtVenctoOrigDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 22ch" value="${valor}">`;
                    }
                    case 2: {
                        return `<input type="date" id="txtVenctoDesdobra_${indices.row}"
                                class="input-default focus form-control"
                                style="width: 22ch" value="${valor}">`;
                    }
                    case 3: {
                        return `<input type="text" id="txtDiaSemanaDesdobra_${indices.row}"
                                class="input-default focus form-control tamanhoDinamico"
                                style="min-width: 15ch; max-width: 20ch" value="${valor}">`;
                    }
                    case 4: {
                        return `<input type="text" id="txtValorDesdobra_${indices.row}"
                                class="input-default focus form-control text-right apenasFloat inputValorTabela"
                                style="width: 15ch" value="${valor}">`;
                    }
                    case 5: {
                        const value = valor != '' ? insereValor(`#txtBancoDesdobra_${indices.row}`, valor, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: valor }) : '';

                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeBancoDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtBancoDesdobra_${indices.row}" name="txtBancoDesdobra_${indices.row}" placeholder="Banco">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnBancoDesdobra_${indices.row}" name="btnBancoDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaBancoDesdobra_${indices.row}" name="btnLimpaBancoDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 6: {
                        const value = valor != '' ? insereValor(`#txtClasseDesdobra_${indices.row}`, valor, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: valor }) : '';

                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeClasseDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtClasseDesdobra_${indices.row}" name="txtClasseDesdobra_${indices.row}" placeholder="Classe">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnClasseDesdobra_${indices.row}" name="btnClasseDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaClasseDesdobra_${indices.row}" name="btnLimpaClasseDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 7: {
                        const valorPadrao = valoresPadroes.find(item => item.CAMPO === 'HISTORICO_DESD' && item.VALOR !== '');
                        const valorReal = valorPadrao ? valorPadrao.VALOR : valor;
                        const value = insereValor(`#txtHistoricoDesdobra_${indices.row}`, valorReal, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: valorReal });

                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeHistoricoDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtHistoricoDesdobra_${indices.row}" name="txtHistoricoDesdobra_${indices.row}" placeholder="Histórico">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnHistoricoDesdobra_${indices.row}" name="btnHistoricoDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaHistoricoDesdobra_${indices.row}" name="btnLimpaHistoricoDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 8: {
                        const valorPadrao = valoresPadroes.find(item => item.CAMPO === 'SITUACAO_DESD' && item.VALOR !== '');
                        const valorReal = valorPadrao ? valorPadrao.VALOR : valor;
                        const value = insereValor(`#txtSituacaoDesdobra_${indices.row}`, valorReal, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: valorReal });

                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeSituacaoDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtSituacaoDesdobra_${indices.row}" name="txtSituacaoDesdobra_${indices.row}" placeholder="Situação">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnSituacaoDesdobra_${indices.row}" name="btnSituacaoDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaSituacaoDesdobra_${indices.row}" name="btnLimpaSituacaoDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 9: {
                        const valorPadrao = valoresPadroes.find(item => item.CAMPO === 'CONTA' && item.VALOR !== '');
                        const valorReal = valorPadrao ? valorPadrao.VALOR : valor;
                        const value = !valorReal ? '' : insereValor(`#txtContaDesdobra_${indices.row}`, valorReal, { tabela: 'CADCONTA', campoBusca: 'DESCRICAO', campoWhere: 'CONTA', valorWhere: valorReal });

                        return `<div class="input-group-append">
                                    <input type="text" value="${value}"
                                    class="input-default focus form-control validate classeContaDesdobra" style="min-width: 40ch; max-width: 50ch" id="txtContaDesdobra_${indices.row}" name="txtContaDesdobra_${indices.row}" placeholder="Conta">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnContaDesdobra_${indices.row}" name="btnContaDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaContaDesdobra_${indices.row}" name="btnLimpaContaDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    case 10: {
                        return `<input type="text" id="txtObservacaoDesdobra_${indices.row}"
                                class="input-default focus form-control tamanhoDinamico"
                                style="min-width: 30ch; max-width: 50ch" value="${valor}">`;
                    }
                    case 11: {
                        return `<input type="text" id="txtNSUDesdobra_${indices.row}"
                                class="input-default focus form-control tamanhoDinamico"
                                style="min-width: 20ch; max-width: 30ch" value="${valor}">`;
                    }
                    case 12: return valor;
                    case 13: {
                        return `<div class="input-group-append">
                                    <input type="text" value=""
                                    class="input-default focus form-control validate classePedidoDesdobra" style="min-width: 20ch; max-width: 30ch" id="txtPedidoDesdobra_${indices.row}" name="txtPedidoDesdobra_${indices.row}" placeholder="Pedido">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnPedidoDesdobra_${indices.row}" name="btnPedidoDesdobra_${indices.row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaPedidoDesdobra_${indices.row}" name="btnLimpaPedidoDesdobra_${indices.row}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>`;
                    }
                    default:
                        break;
                }

            } catch (e) {
                msgErro(`Não foi possível carregar os dados: ${e}`);
                console.log(e);
            }

        }

        if ($.fn.DataTable.isDataTable('#tabelaDupliGeradasDesdobra')) {
            $('#tabelaDupliGeradasDesdobra').DataTable().destroy();
            $('#tabelaDupliGeradasDesdobra').empty();
        }

        const cols = [{
            data: 'DUPLICATA',
            title: 'Duplicata'
        },
        {
            data: 'DT_VENCTOORIG',
            title: 'Vencimento Original'
        },
        {
            data: 'DT_VENCTO',
            title: 'Vencimento'
        },
        {
            data: 'DIASEMANA',
            title: 'Dia Semana'
        },
        {
            data: 'VALOR',
            title: 'Valor'
        },
        {
            data: 'BANCO',
            title: 'Banco'
        },
        {
            data: 'CLASSE',
            title: 'Classe'
        },
        {
            data: 'HISTORICO',
            title: 'Histórico'
        },
        {
            data: 'SITUACAO',
            title: 'Situação'
        },
        {
            data: 'CONTA',
            title: 'Conta'
        },
        {
            data: 'OBS',
            title: 'Observação'
        },
        {
            data: 'CARTAO_NSU',
            title: 'Cartão NSU'
        },
        {
            data: 'VALORCUB',
            title: 'Valor Cub.'
        },
        {
            data: 'PEDIDO',
            title: 'Pedido'
        }]

        $("#tabelaDupliGeradasDesdobra").DataTable({
            order: false,
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            searching: false,
            info: false,
            autoWidth: true,
            data: info,
            columns: cols,
            columnDefs: [
                {
                    targets: [11],
                    visible: false
                },
                {
                    targets: '_all',
                    render: function (data, v2, v3, index) {
                        return carregaInput(data, index);
                    }
                },
            ],
        });

        $('#labelTotalSoma').html(parseFloat($('#tabelaDupliGeradasDesdobra').DataTable().data().toArray().reduce((e, o) => {
            return e + o.VALOR;
        }, 0)).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        })
        );

        $('#labelTotalSaldo').html((parseFloat($('#labelTotalValor').html().replaceAll('.', '').replaceAll(',', '.')) - (parseFloat($('#labelTotalSoma').html().replaceAll('.', '').replaceAll(',', '.')))).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        })
        );

        $('.inputValorTabela').on('blur', function () {
            $('#labelTotalSoma').html(parseFloat($('#tabelaDupliGeradasDesdobra').DataTable().data().toArray().reduce((e, o, i) => {
                return e + parseFloat($(`#txtValorDesdobra_${i}`).val());
            }, 0)).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            })
            );

            $('#labelTotalSaldo').html((parseFloat($('#labelTotalValor').html().replaceAll('.', '').replaceAll(',', '.')) - (parseFloat($('#labelTotalSoma').html().replaceAll('.', '').replaceAll(',', '.')))).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            })
            );
        })

        $('.tamanhoDinamico').on('input', function () {
            this.style.width = this.value.length + "ch";
        });

        $('.tamanhoDinamico').trigger('input');
        adicionaMascaraCampos();

        adicionaPesquisasInputs();

        if ($('#cbConsParcelaDup').is(':checked')) {
            const dataTable = $('#tabelaDupliGeradasDesdobra').DataTable();
            dataTable.rows().every(function (rowIdx) {
                const data = this.data();
                const indices = { row: rowIdx, col: 0 };
                atualizaValor(indices);
            });
        }

        rotinaSaidaCampo()

    }

    $('#cbGeraSeqDesdobra').on('change', function () {
        if ($('#cbGeraSeqDesdobra').prop('checked')) {
            $('#cbNumeroDupliDesdobra').prop('disabled', true);
            $('#cbNumeroDupliDesdobra').prop('checked', false);
        } else {
            $('#cbNumeroDupliDesdobra').prop('disabled', false);
        }
    })

    function rotinaSaidaCampo() {
        setTimeout(() => {
            $('#txtBancoDesdobra_0').off('blur').on('blur', function () {
                const novoValor = $(this).val()
                const codigo = $(this).data().chave
                // const valorAnterior = `[${$(this).data('chave')}] - ${$(this).data('desc')}` || '';

                if (pegaChave(novoValor) != codigo) {
                    msgAlerta(
                        'Deseja aplicar este banco para todas as duplicatas?',
                        () => {
                            alterarTodosRegistros(novoValor, 'Banco');
                        },
                        () => { }
                    );
                }

                $(this).data({ chave: pegaChave(this), desc: pegaDescricao(this) });
            });


            $('#txtClasseDesdobra_0').off('focusout').on('focusout', function () {
                const novoValor = $(this).val()
                const codigo = $(this).data().chave
                // const valorAnterior = `[${$(this).data('chave')}] - ${$(this).data('desc')}` || '';

                if (pegaChave(novoValor) != codigo) {
                    msgAlerta(
                        'Deseja aplicar esta classe para todas as duplicatas?',
                        () => {
                            alterarTodosRegistros(novoValor, 'Classe');
                        },
                        () => { }
                    );
                }

                $(this).data({ chave: pegaChave(this), desc: pegaDescricao(this) });
            });


            $('#txtHistoricoDesdobra_0').off('blur').on('blur', function () {
                const novoValor = $(this).val()
                const codigo = $(this).data().chave
                // const valorAnterior = `[${$(this).data('chave')}] - ${$(this).data('desc')}` || '';

                if (pegaChave(novoValor) != codigo) {
                    msgAlerta(
                        'Deseja aplicar este histórico para todas as duplicatas?',
                        () => {
                            alterarTodosRegistros(novoValor, 'Historico');
                        },
                        () => { }
                    );
                }

                // $(this).data({ chave: pegaChave(this), desc: pegaDescricao(this) });
            });


            $('#txtSituacaoDesdobra_0').off('blur').on('blur', function () {
                const novoValor = $(this).val()
                const codigo = $(this).data().chave
                // const valorAnterior = `[${$(this).data('chave')}] - ${$(this).data('desc')}` || '';

                if (pegaChave(novoValor) != codigo) {
                    msgAlerta(
                        'Deseja aplicar esta situação para todas as duplicatas?',
                        () => {
                            alterarTodosRegistros(novoValor, 'Situacao');
                        },
                        () => { }
                    );
                }

                $(this).data({ chave: pegaChave(this), desc: pegaDescricao(this) });
            });


            $('#txtContaDesdobra_0').off('blur').on('blur', function () {
                const novoValor = $(this).val();
                const codigo = $(this).data().chave
                // const valorAnterior = `[${$(this).data('chave')}] - ${$(this).data('desc')}` || '';

                if (pegaChave(novoValor) != codigo) {
                    msgAlerta(
                        'Deseja aplicar esta conta para todas as duplicatas?',
                        () => {
                            alterarTodosRegistros(novoValor, 'Conta');
                        },
                        () => { }
                    );
                }

                $(this).data({ chave: pegaChave(this), desc: pegaDescricao(this) });
            });
        }, 200)

    }

    function adicionaPesquisasInputs() {
        try {
            // { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: valor }
            // { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: valor }
            // { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: valor }
            // { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: valor }

            $('.classeBancoDesdobra').map(function (e, i) {
                $(`#txtBancoDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
                $(`#btnBancoDesdobra_${e}`).pesquisa(`#txtBancoDesdobra_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADBAN","camposSelect": ["CADBAN.BANCO CODIGO", "CADBAN.NOME_BANCO DESCRICAO"]}`, 'Pesquisa Banco', 'CADBAN');
                $(`#btnLimpaBancoDesdobra_${e}`).on('click', function () {
                    $(`#txtBancoDesdobra_${e}`).val('');
                });

                $(`#txtClasseDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $(`#btnClasseDesdobra_${e}`).pesquisa(`#txtClasseDesdobra_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CLASSE_GER","camposSelect": ["CLASSE_GER.CODIGO CODIGO", "CLASSE_GER.DESCRICAO DESCRICAO"]}`, 'Pesquisa Classe', 'CLASSE_GER');
                $(`#btnLimpaClasseDesdobra_${e}`).on('click', function () {
                    $(`#txtClasseDesdobra_${e}`).val('');
                });

                $(`#txtHistoricoDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $(`#btnHistoricoDesdobra_${e}`).pesquisa(`#txtHistoricoDesdobra_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "HISTCP", "camposSelect": ["HISTCP.HISTORICO CODIGO", "HISTCP.DESCRICAO DESCRICAO"]}`, 'Pesquisa Histórico', 'HISTCP');
                $(`#btnLimpaHistoricoDesdobra_${e}`).on('click', function () {
                    $(`#txtHistoricoDesdobra_${e}`).val('');
                });

                $(`#txtSituacaoDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $(`#btnSituacaoDesdobra_${e}`).pesquisa(`#txtSituacaoDesdobra_${e}`, 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABSIT", "camposSelect": ["TABSIT.CODIGO CODIGO", "TABSIT.DESCRICAO DESCRICAO"]}`, 'Pesquisa Situação', 'TABSIT');
                $(`#btnLimpaSituacaoDesdobra_${e}`).on('click', function () {
                    $(`#txtSituacaoDesdobra_${e}`).val('');
                });

                $(`#txtContaDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $(`#btnContaDesdobra_${e}`).pesquisa(`#txtContaDesdobra_${e}`, 'CONTA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCONTA", "camposSelect": ["CADCONTA.CONTA", "CADCONTA.DESCRICAO DESCRICAO"]}`, 'Pesquisa Conta', 'CADCONTA');
                $(`#btnLimpaContaDesdobra_${e}`).on('click', function () {
                    $(`#txtContaDesdobra_${e}`).val('');
                });

                const codCli = $('#tabelaDupliSelDesdobra').DataTable().data().toArray()[0]?.CODCLI;
                $(`#txtPedidoDesdobra_${e}`).autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO"], "innerjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela" : "PED_ITEN", "condicao" : "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "groupby":  ["PEDIDO.NUMERO", "ENTIDADE.NOME"], "having": ["SUM(PED_ITEN.QTDE) > 0"], "where": ["PEDIDO.CODCLI = '${codCli}'"]}`);
                $(`#btnPedidoDesdobra_${e}`).pesquisa_serverside([`#txtPedidoDesdobra_${e}`], ["PEDIDO.NUMERO"], ["ENTIDADE.NOME"], `{
                    "tabela":"PEDIDO", 
                    "camposSelectSubSelect": ["NUMERO", "CODCLI", "NOME", "DT_EMISSAO", "DT_FATURA"],
                    "camposSelect":[
                        "PEDIDO.NUMERO", 
                        "PEDIDO.CODCLI",
                        "ENTIDADE.NOME", 
                        "PEDIDO.DT_EMISSAO", 
                        "PEDIDO.DT_FATURA",
                        "SUM(QTDE) QTDE"
                    ], 
                    "innerjoin": [
                        {"tabela" : "PED_ITEN", "condicao" : "PED_ITEN.NUMERO = PEDIDO.NUMERO"},
                        {"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}
                    ],
                    "groupby":  ["PEDIDO.NUMERO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "PEDIDO.DT_EMISSAO", "PEDIDO.DT_FATURA"],  
                    "groupBySubSelect": ["NUMERO", "CODCLI", "NOME", "DT_EMISSAO", "DT_FATURA", "QTDE"],
                    "having": ["SUM(QTDE) > 0"],
                    "where": ["PEDIDO.CODCLI = '${codCli}'"]
                }`, 'Pesquisa de Pedido');
                $(`#btnLimpaPedidoDesdobra_${e}`).on('click', function () {
                    $(`#txtPedidoDesdobra_${e}`).val('');
                });
            });

            rotinaSaidaCampo()

        } catch (e) {
            console.log(e);
        }
    }

    function alterarTodosRegistros(novoValor, tipoInput) {
        let classe;

        switch (tipoInput) {
            case 'Conta':
                classe = '.classeContaDesdobra';
                break;
            case 'Banco':
                classe = '.classeBancoDesdobra';
                break;
            case 'Classe':
                classe = '.classeClasseDesdobra';
                break;
            case 'Historico':
                classe = '.classeHistoricoDesdobra';
                break;
            case 'Situacao':
                classe = '.classeSituacaoDesdobra';
                break;
            default:
                classe = '.classeContaDesdobra';
        }

        $(classe).each(function () {
            $(this).val(novoValor);
        });
    }

    $('#btnGravarDesdobra').on('click', async function () {
        $.LoadingOverlay('show');
        let bAbort = true;
        const BoaVistaSPC = $("#modal-desdobra-receber").prop("BoaVistaSPC");
        try {
            await msgAguardaConfirmacao("Deseja gravar os dados?", () => { bAbort = false; }, () => { })
            if (!bAbort) {
                if (bRemoverClienteSPC && await removerClienteSPC(BoaVistaSPC)) {
                    bRemoverClienteSPC = null;
                }
                await gravaDados();
            }
        } catch (error) {
            console.log(error);
            msgAlerta(error.message);
        }
        finally {
            $.LoadingOverlay('hide');
        }
    });

    async function gravaDados() {
        try {
            validaCampoPedido();

            let primeiroRegistro = $('#tabelaDupliSelDesdobra').DataTable().row($('tr.selected')).data();

            const duplicatasOriginais = [primeiroRegistro];

            $('#tabelaDupliSelDesdobra').DataTable().data().toArray().map(function (e) {
                if (e.NUMERO != primeiroRegistro.NUMERO) {
                    duplicatasOriginais.push(e)
                }
            });

            $('#tabelaDupliSelDesdobra').DataTable().data().toArray()
            const filtros = retornaFiltros();
            const originais = { DUPLICATAS: duplicatasOriginais }
            const desdobradas = { DUPLICATAS: retornaDuplicatasDesdobradas() }
            const valor = $('#labelTotalValor').html();
            const soma = $('#labelTotalSoma').html();

            let response = await requisicao("POST", `/Sisplan/desdobrareceber/V1/gravadados?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
                `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&ORIGINAIS=${encodeURIComponent(JSON.stringify(originais))}&DESDOBRADAS=${encodeURIComponent(JSON.stringify(desdobradas))}&VALOR=${valor}&SOMA=${soma}`);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                let json = await response.json();
                msgErro(json.mensagem);
                return;
            }

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                async onHidden() { $('#modal-desdobra-receber').modal('hide') },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível gravar os dados: ${e.message}`);
        }
    }

    function retornaDuplicatasDesdobradas() {
        const retorno = [];

        $('#tabelaDupliGeradasDesdobra').DataTable().data().toArray().map(function (e, i) {
            retorno.push({
                BANCO: pegaChave(`#txtBancoDesdobra_${i}`),
                CARTAO_NSU: $(`#txtNSUDesdobra_${i}`).val() || '',
                CLASSE: pegaChave(`#txtClasseDesdobra_${i}`),
                DIASEMANA: $(`#txtDiaSemanaDesdobra_${i}`).val(),
                DT_VENCTO: $(`#txtVenctoDesdobra_${i}`).val(),
                DT_VENCTOORIG: $(`#txtVenctoOrigDesdobra_${i}`).val(),
                DUPLICATA: $(`#txtDupliDesdobra_${i}`).val(),
                HISTORICO: pegaChave(`#txtHistoricoDesdobra_${i}`),
                OBS: $(`#txtObservacaoDesdobra_${i}`).val(),
                SITUACAO: pegaChave(`#txtSituacaoDesdobra_${i}`),
                CONTA: pegaChave(`#txtContaDesdobra_${i}`),
                VALOR: $(`#txtValorDesdobra_${i}`).val(),
                VALORCUB: e.VALORCUB,
                PEDIDO: pegaChave(`#txtPedidoDesdobra_${i}`),
            })
        });

        return retorno;
    }

    $('#txtIntervaloDesdobra').on('blur', function () {
        if ($(this).val() == '30') {
            $('#cbVenctoDiaDesdobra').prop('checked', true);
        }
    })

    $('#modal-desdobra-receber').on('hide.bs.modal', async function () {
        $.LoadingOverlay('show');
        try {
            if ($.fn.DataTable.isDataTable('#tabelaDupliSelDesdobra')) {
                $('#tabelaDupliSelDesdobra').DataTable().destroy();
                $('#tabelaDupliSelDesdobra').empty();
            }
            if ($.fn.DataTable.isDataTable('#tabelaDupliAssDesdobra')) {
                $('#tabelaDupliAssDesdobra').DataTable().destroy();
                $('#tabelaDupliAssDesdobra').empty();
            }
            if ($.fn.DataTable.isDataTable('#tabelaDupliGeradasDesdobra')) {
                $('#tabelaDupliGeradasDesdobra').DataTable().destroy();
                $('#tabelaDupliGeradasDesdobra').empty();
            }

            $('#divDesdobradas div input, #divDesdobradas div select, #divDesdobradas div button').prop('disabled', false);
            $('#btnGravarDesdobra').prop('disabled', false);

            $('#divDesdobradas div input').val('');
            $('#txtMetodoDesdobra').val('JS');
            $('#divDesdobradas div input[type="checkbox"]').prop('checked', false);

            $('#divSelecionadas div input').val('');
            $('.labelTotais').html('');
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnCancelarDesdobra').on('click', function () {
        $('#modal-desdobra-receber').modal('hide');
    })

    function validaCampoPedido() {
        if (validarCampoPedido) {
            let bAnte = false;
            const dados = $('#tabelaDupliSelDesdobra').DataTable().data().toArray();
            dados.forEach(item => {
                if (item.STATUS == 'ANTE') {
                    bAnte = true;
                }
            });

            if (bAnte) {
                $('.classePedidoDesdobra').each((index) => {
                    if (pegaChave($($(".classePedidoDesdobra")[index]).val()) == '') {
                        throw new Error('Necessário informar o campo pedido em todas duplicatas, impossível continuar!');
                    }
                })
            }
        }
    }

    function bloqueiaTelaClienteSPC(bloqueia = true) {
        $("#btnGravarDesdobra").prop("disabled", bloqueia);
        $("#btnTrocarClienteDesdobra").prop("disabled", bloqueia);
    }

});