<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Notas Fiscais de Compra</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.259.2.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.259.2.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.259.2.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.259.2.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.259.2.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.259.2.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.259.2.1" />
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.259.2.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.259.2.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.259.2.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.259.2.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    .table.dataTable tbody td {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    #divTabelaNotas .dataTables_scrollHeadInner table {
      width: 100% !important;
    }

    #divTabelaNotas .dataTables_scrollHeadInner {
      width: 100% !important;
    }

    .bordaCampos {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 2%;
      padding-bottom: 0%;
    }

    .bordaCampos:first-child {
      display: flex;
      flex-direction: row;
      flex-wrap: wrap;
      justify-content: flex-end;
      align-items: center;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Relatório de Notas Fiscais de Compra</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
            </div>
          </div>
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="col-sm-12 mt-2">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
              <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
            </div>
            <div class="row">
              <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                <div id="graficosNotas" class="mt-5" style="width: 100%;"></div>
              </div>
              <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                <div id="graficosNotas1" class="mt-5" style="width: 100%;"></div>
              </div>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Notas</h5>
              <table id="tabelaNotas" class="table table-sm-sisp table-select table-hover" width="100%">
              </table>
            </div>
          </div>

          <div class="d-flex gap-2 row">
            <div class="table-responsive card card-body col-12">
              <h5>Itens</h5>
              <table id="tabelaNotasVisualizacao" class="table table-sm-sisp table-select table-hover" width="100%">
                <thead></thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header d-flex">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-12 d-flex align-items-center flex-wrap gap-px">
                <div class="">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda pb-0 mb-0">Tipo</legend>
                    <div class="form-row justify-content-around">
                      <div class="d-flex">
                        <div class="radio-group form-radio icheck-primary"><input type="radio" id="rdTipoTodos" checked name="tipo"><label for="rdTipoTodos" class="container escondeRadio">Todos</label></div>
                        <div class="radio-group form-radio icheck-primary"><input type="radio" id="rdTipoMaterial" name="tipo"><label for="rdTipoMaterial" class="container escondeRadio">Material</label></div>
                        <div class="radio-group form-radio icheck-primary"><input type="radio" id="rdTipoProduto" name="tipo"><label for="rdTipoProduto" class="container escondeRadio">Produto</label></div>
                        <div class="radio-group form-radio icheck-primary"><input type="radio" id="rdTipoServico" name="tipo"><label for="rdTipoServico" class="container escondeRadio">Serviço</label></div>
                      </div>
                    </div>
                  </fieldset>
                </div>  
                <button class="btn btn-danger btn-sisp mt-1" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>
              </div>
            </div>
            <div class="row">

              <div class="col-md-6 col-12">
                <label data-error="wrong" data-success="right" for="dtEmissaoDe">Emissão De/ Até: </label>
                <div class="relative">
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEmissaoDe" name="dtEmissaoDe" class="form-control">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEmissaoAte" name="dtEmissaoAte" class="form-control">
                  </div>
                </div>
              </div>
              <div class="col-md-6 col-12">
                <label data-error="wrong" data-success="right" for="dtEntradaDe">Entrada De/ Até: </label>
                <div class="relative">
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEntradaDe" name="dtEntradaDe" class="form-control">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEntradaAte" name="dtEntradaAte" class="form-control">
                  </div>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12" id="inputProduto">
                <label data-error="wrong" data-success="right" for="txtProduto">Produto: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6 col-lg-4 col-12" id="inputMaterial">
                <label data-error="wrong" data-success="right" for="txtMaterial">Material: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtMaterial" name="txtMaterial" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMaterial" name="btnMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12" id="inputServico">
                <label data-error="wrong" data-success="right" for="txtServico">Serviço: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtServico" name="txtServico" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnServico" name="btnServico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaServico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtCor">Cor: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtCor" name="txtCor" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCor" name="btnCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6 col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtTamanho">Tamanho: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtTamanho" name="txtTamanho" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnTamanho" name="btnTamanho" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaTamanho" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6 col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtLote">Lote: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtLote" name="txtLote" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnLote" name="btnLote" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaLote" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtOrdemCompra">Ordem Compra: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtOrdemCompra" name="txtOrdemCompra" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnOrdemCompra" name="btnOrdemCompra" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaOrdemCompra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtNotaEntra">Notas: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtNotaEntra" name="txtNotaEntra" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnNotaEntra" name="btnNotaEntra" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaNotaEntra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtFornecedor">Fornecedor: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtFornecedor" name="txtFornecedor" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnFornecedor" name="btnFornecedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaFornecedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtDeposito">Depósito: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnDeposito" name="btnDeposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaDeposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtNatureza">Natureza: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtNatureza" name="txtNatureza" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnNatureza" name="btnNatureza" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaNatureza" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">

              <!-- <div class="col-md-6 col-lg-3 col-12">
                <div class="form-group">
                  <label>Buscar XML: </label>
                  <select class="form-control select2 select2-danger" id="selectXML" name="selectXML" data-dropdown-css-class="select2-danger" style="width: 100%;">
                    <option selected="selected" value="">Todas</option>
                    <option value="1">Com XML</option>
                    <option value="2">Sem XML</option>
                  </select>
                </div>
              </div> -->

              <div class="col-md-6 col-lg-4 col-12">
                <div class="form-group">
                  <label>Duplicatas: </label>
                  <select class="form-control select2 select2-danger" id="selectDuplicatas" name="selectDuplicatas" data-dropdown-css-class="select2-danger" style="width: 100%;">
                    <option selected="selected" value="">Todas</option>
                    <option value="1">Com</option>
                    <option value="2">Sem</option>
                  </select>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12">
                <div class="form-group">
                  <label>Notas: </label>
                  <select class="form-control select2 select2-danger" id="selectNotas" name="selectNotas" data-dropdown-css-class="select2-danger" style="width: 100%;">
                    <option selected="selected" value="">Todas</option>
                    <option value="1">Com Ord. Compra</option>
                    <option value="2">Sem Ord. Compra</option>
                  </select>
                </div>
              </div>

              <div class="col-md-6 col-lg-4 col-12">
                <div class="form-group">
                  <label>Movimento Estoque: </label>
                  <select class="form-control select2 select2-danger" id="selectMovimento" name="selectMovimento" data-dropdown-css-class="select2-danger" style="width: 100%;">
                    <option selected="selected" value="">Todas</option>
                    <option value="1">Com Movimento</option>
                    <option value="2">Sem Movimento</option>
                  </select>
                </div>
              </div>
            </div>


            <!-- <div class="col-lg-3  col-3">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtOrdem">Ordem Impressão: </label>
                <div class="input-group">
                  <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="txtOrdem" class="custom-select">
                  </select>
                </div>
              </div> -->

          </div>
          <div class="modal-footer">
            <div class="row">
              <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>   
              <button id="btnConsultar" class='btn btn-primary btn-sisp' type='button'><span class="fas fa-search"></span> Consultar </button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
    <?php include_once('../../modais.php'); ?>
  </main><!-- /.wrapper -->

  <script src="plugins/jquery/jquery.min.js?versao=3.259.2.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.259.2.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.259.2.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.259.2.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.259.2.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.259.2.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.259.2.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.259.2.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.259.2.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.259.2.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.259.2.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.259.2.1"></script>
  <script src="dist/js/sisplan.js?versao=3.259.2.1"></script>
  <script src="utils/funcoes.js?versao=3.259.2.1"></script>
  <script src="utils/cookies.js?versao=3.259.2.1"></script>
  <script src="dist/js/driver.min.js?versao=3.259.2.1"></script>
  <script src="config.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.259.2.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.259.2.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.259.2.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.259.2.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELNFENTRA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relnfentra/relnfentra.js?versao=3.259.2.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      // nomeTela


      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>